/******************************************************************************/
class StopSound : BaseEvent
{
public:
            StopSound();
   virtual ~StopSound();
   
   virtual void create(Object &obj); 
   virtual void AfterCreate(      );
   
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();

   Memc<UID> m_VarAudioUIDs;
   Memc<VarAudio*> m_VarAudios;
   
   flt m_Volume, m_FadeOutTime;
};
/******************************************************************************/
StopSound::StopSound() : BaseEvent(), m_Volume(0), m_FadeOutTime(0)                         
{

}
StopSound::~StopSound()
{
   
}
/******************************************************************************/
void StopSound::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("FadeOutTime")) m_FadeOutTime = p.asFlt();
   for(int i = 1; i < 10; ++i) 
      if(Param *p = obj.findParam(S + "VarAudioUID" + i)) 
         if(p.asID().valid()) m_VarAudioUIDs.add(p.asID()); 

   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void StopSound::AfterCreate()
{
   // Find the correct VarAudios to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPAD(i, variablesAudio)
      REPAD (j, m_VarAudioUIDs)
         if(variablesAudio[i].id() == m_VarAudioUIDs[j])
            m_VarAudios.add(&variablesAudio[i]);
            
   DEBUG_ASSERT(m_VarAudioUIDs.elms() == m_VarAudios.elms(), "StopSound: Not all audio was found in the scene");
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void StopSound::CallTriggeredAction()
{
   REPA(m_VarAudios)
   {
      if(m_FadeOutTime > 0)
      {
         m_VarAudios[i]->GetAudio().fadeOut(m_FadeOutTime);  
      }
      else
      {
         m_VarAudios[i]->GetAudio().stop();
      }         
   }
}

// This method is called when the duration of the event has been reached
void StopSound::StopTriggeredAction()
{
   
}
/******************************************************************************/